//========================================================================
//Calculated h and hr values in textbook are rounded of to 33.9 and 13.9 respectively whereas in openmodelica h and hr values are taken as such without rounding off due to which their is slight deviation in value of q in open modelica to textbook answer.
//Kindly check textbook for ur reference

//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 40, Exercise - 1.10
//Title : Convection and Radiation in parallel
//=========================================================================

model Ex1_10

//=========================================================================
//Variable section
Real hr(unit = "W/m2.K") "Radiation heat transfer coefficient";
Real h(unit = "W/m2.K") "Combined heat transfer coefficient";
Real q(unit = "W") "Rate of heat loss per meter";

//=========================================================================
//Parameter Section
parameter Real Epsilon = 0.9;
parameter Real sigma(unit = "W/m2.K4") = 5.67e-8 "Stefan Boltzman constant";
parameter Real hc(unit = "W/m2.K") = 20 "Heat transfer coefficicent between the pipe surface and the air in the room";
parameter Real T_pipe(unit = "K") = 500 "Surface temperature";
parameter Real T_air(unit = "K") = 300 "Temperature of room where pipe is located";
parameter Real L(unit = "m") = 1 "Length of pipe";
parameter Real D(unit = "m") = 0.5 "Diameter of pipe";


//=========================================================================
//Library Section
extends Modelica.Constants;


//=========================================================================
//Equation Section
equation
hr = sigma*Epsilon*(((T_pipe^2)+(T_air^2))*(T_pipe + T_air));
h = hr + hc;
q = pi*D*L*h*(T_pipe - T_air);
//=========================================================================

end Ex1_10;