//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 27, Exercise - 1.6
//Title: Plane walls in series and parallel
//=========================================================================


package Ex1_6
class Ex1_6_a

//Variable section
//=========================================================================

Real q(unit = "W/m2.K") "Rate of heat flow per unit area";
Real R1(unit = "m2.K/W") "Thermal resistance";
Real R3(unit = "m2.K/W") "Thermal resistance";

//=========================================================================
//Parameter Section
parameter Real Ts1(unit = "deg.C") = 405 "Temperature";
parameter Real Ts3(unit = "deg.C") = 395 "Outside temperature";
parameter Real L(unit = "m") = 0.01 "Length";
parameter Real k(unit = "W/m.K") = 240 "Thermal conductivity";
parameter Real R2(unit = "W/m2.K") = 2.75e-4 "Thermal resistance";


//=========================================================================
//Equation Section
equation
R1 = L/k;
R3 = R1;
q = ((Ts1 - Ts3)/(R1 + R2 + R3));

end Ex1_6_a;

  class Ex1_6_b
  //Variable section
  //=========================================================================
  Real x "Fraction of contact resistance";
  
  //=========================================================================
  //Parameter Section
  parameter Real R2(unit = "W/m2.K") = 2.75e-4 "Thermal resistance";
  parameter Real R(unit = "W/m2.K") = 3.584e-4  "Resistance";
  
  
  //=========================================================================
  //Equation Section
  equation
  x = R2/R;
  
  //=========================================================================
  
  end Ex1_6_b;
end Ex1_6;
