//========================================================================
//Calculated Kk value in OpenModelica is as such taken to calculate q_A whereas in textbook Kk value is rounded of and calculated q_A value due to which their is small deviation in q_A value from textbook answer
//========================================================================

//========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 29, Exercise - 1.7
//Title: Plane walls in series and parallel
//========================================================================

class Ex1_7
//Variable section
//=========================================================================
Real R3(unit = "hr.ft2.deg F/Btu") "Thermal resistance of the steel plate";
Real R4(unit = "hr.ft2.deg F/Btu") "Thermal resistance of the brick asperities";
Real R5(unit = "hr.ft2.deg F/Btu") "Thermal resistance of the air trapped between the asperities";
Real R2(unit = "hr.ft2.deg F/Btu") "Total thermal resistance for the two paths";
Real R1(unit = "hr.ft2.deg F/Btu") "Thermal resistance of half of the solid brick";
Real Kk(unit = "Btu/h.degF.ft2") "Overall unit conductance";
Real q_A(unit = "Btu/hr.ft2") "Rate of heat flow per unit area";

//Parameter Section
//=========================================================================
parameter Real L3(unit = "in") = 0.25 "Length";
parameter Real L2(unit = "in") = 0.03125 "Length";
parameter Real L1(unit = "in") = 1 "Length";
parameter Real ks(unit = "Btu/h.degF.ft") = 30 "Thermal conductivity";
parameter Real kb(unit = "Btu/h.degF.ft") = 1 "Thermal conductivity";
parameter Real ka(unit = "Btu/h.degF.ft") = 0.02 "Thermal conductivity";
parameter Real T1(unit = "deg F") = 200 "Surface temperature of steel";
parameter Real T2(unit = "deg F") = 800 "Surface temperature of steel";

//Equation section
//=========================================================================
equation
R3 = L3/(12*ks);
R4 = L2/(0.3*12*kb);
R5 = L2/(12*0.7*ka);
//12 is multiplied to convert feet to inches
R2 = ((R4*R5)/(R4+R5));
R1 = L1/(12*kb);
Kk = (1/(2*(R1+R2+R3)));
q_A = Kk*(T2 - T1);
//=========================================================================



end Ex1_7;