//Rk_SS answer in textbook is wrong when calculated by hand it is 0.0069 K/W whereas in textbook it is 0.07 K/W because of which q_max and R_total answer is also wrong. Kindly check textbook answer if u have doubt
//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 35, Exercise - 1.8
//Title : Contact resistance
//=========================================================================

class Ex1_8
//=========================================================================
//Variable section
Real Rk_SS(unit = "K/W") "Thermal resistance of stainless steel metal plates";
Real Rk_Du(unit = "K/W") "Thermal resistance of Duralumin metal plates";
Real Ri(unit = "K/W") "Contact resistance";
Real R_total(unit = "K/W") "Total thermal resistance";
Real q_max(unit = "W") "Maximum allowable rate of heat dissipation";

//=========================================================================
//Parameter Section
parameter Real L_SS(unit = "m") = 0.01 "Length of stainless steel plate";
parameter Real L_A1(unit = "m") = 0.02 "Length of duralumin plate";
parameter Real A(unit = "m2") = 0.01 "Area";
parameter Real k_SS(unit = "W/m.K") = 144 "Thermal conductivity of stainless steel";
parameter Real k_A1(unit = "W/m.K") = 164 "Thermal conductivity of Duralumin";
parameter Real T1(unit = "deg.C") = 0 "Initial temperature";
parameter Real T2(unit = "deg.C") = 40 "Final Temperature";
parameter Real c(unit = "m2.K/kW") = 0.5 "Unit constant resistance from Fig 1.20";

//=========================================================================
//Equation Section
equation
Rk_SS = L_SS/(A*k_SS);
Rk_Du = L_A1/(A*k_A1);
Ri = c/(1000*A); 
//1000 is divided to convert W to kW
R_total = Rk_SS + Rk_Du + Ri;
q_max = (T2 - T1)/R_total;
//=========================================================================

end Ex1_8;