//Textbook answer is wrong 

//==========================================================================
//Chapter-10, Heat transfer with phase change 
//Page No.: 682 , Exercise - 10.6
//Title: Heat pipes
//==========================================================================

model Ex10_6

//==========================================================================
//Variable section
Real Aw(unit = "m2") "Area of the wick";
Real m_max(unit = "Kg/s") "Maximum liquid flowrate";
Real q_max(unit = "W") "Maximum heat transport";

//==========================================================================
//Parameter section
parameter Real t(unit = "cm") = 0.0045 "Wire diameter";
parameter Real D(unit = "m") = 0.01 "Diameter";
parameter Real L_eff(unit = "m") = 0.3 "Length";
parameter Real rc(unit = "m") = 0.002e-2 "critical radius";
parameter Real sigma_l(unit = "N/m") = 58.9e-3 "Surface tension";
parameter Real K(unit = "W/m.K") = 0.3e-10 "Thermal conductivity";
parameter Real mu_l(unit = "N/m2.s") = 279e-6 "Viscosity of vapour";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real rho_l(unit = "Kg/m3") = 958 "Density of liquid";
parameter Real teta(unit = "degree") = 0.25 "Density of vapour";
parameter Real hfg(unit = "J/Kg") = 2.26e6 "Enthalpy";
parameter Real m_max1(unit = "Kg/s") = 8.8e-6 "mass flow";

//==========================================================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;


//==========================================================================
//Equation section
equation
Aw = (pi*D*t*4)/100;
m_max = (((2*sigma_l)/rc)-(rho_l*g*L_eff*sin(teta)))*((rho_l*Aw*K)/(mu_l*L_eff));
q_max = m_max1*hfg;

//==========================================================================




end Ex10_6;