//==========================================================================
//Calculated hb value in OpenModelica is as such taken to calculate q whereas in textbook hb value is rounded off and calculated q value due to which their is small deviation in q value from textbook answer
//==========================================================================
//==========================================================================
//Chapter-05, Natural Convection
//Page No: 311, Exercise -5.3
//Title : Empirical Correaltion for Various shapes
//==========================================================================

model Ex5_3
//Variable section
//=========================================================================
Real Ra"Rayleigh number";
Real q(unit= "W") "heat dissipation rate";
Real A(unit= "m2") "area of square plate";
Real Nut  "Nusselt Number from bottom of plate";
Real Nub "Nusselt Number from top of plate";
Real L(unit = "m") " appropriate length Dimension";
Real ht(unit= "W/m2.K") "Heat transfer coefficent for top plae in W/m2";
Real hb(unit= "W/m2.K") "Heat transfer coefficent fro bottom plate in W/m2";

//==========================================================================
//Parameter section
parameter Real Ts(unit = "deg.C") = 227 "Surface temperature";
parameter Real Ta(unit = "deg.C") = 27 "ambient temperature";
parameter Real s (unit ="m")=  1 "side of plate";
parameter Real V(unit = "m2/s") = 2.7e-5 "Kinematic viscosity";
parameter Real g(unit = "m/s2") = 9.8 "acceleration due to gravity";
parameter Real Pr = 0.71 "Prandtl Number";
parameter Real Tm(unit = "deg.c") = 123 "mean temperature";
parameter Real k(unit = "W/m.K") = 0.032"Thermal conductivity";

//==========================================================================
//Equation section
equation
L = (s^2)/(4*s);
A = s*s;
Ra = (g*(Ts-Ta)*(L^3)*Pr)/((V^2)*(Tm+273.15));
Nut = 0.15*(Ra^(1/3));
Nub = 0.27*(Ra^0.25);
ht = (Nut*k)/L;
hb = (Nub*k)/L;
q = A*(ht+hb)*(Ts-Ta);


end Ex5_3;