//==========================================================================
//Calculated w value in OpenModelica is as such taken to calculate Re whereas in textbook w value is rounded of and calculated Re value due to which their is small deviation in Re value from textbook answer
//==========================================================================
//==========================================================================
//Chapter-05, Natural Convection
//Page No: 323, Exercise -5.6
//Title : Rotating Cylinders, Disks, and Spheres
//=========================================================================

model Ex5_6

//Variable section
//=========================================================================

Real w(unit= "rad/s") "Rotating speed of shaft";
Real Re "Reynolds Number ";
Real Ra "Rayleigh number";
Real Nu "Nusselt number";
Real hc(unit= "W/m2.K") "Heat transfer coefficent for convection ";
Real q(unit ="W/m") "rate of heat transfer";


//==========================================================================
//Parameter section
parameter Real rpm(unit = "rev/min") = 3 "rotating speed of shaft";
parameter Real Tc(unit = "deg.C") = 100 "cooled temperature";
parameter Real Ta(unit = "deg.C") = 20 "Air temperature";
parameter Real d (unit ="m")=  0.2 "diameter of steel shaft";
parameter Real V(unit = "m2/s") = 1.94e-5 "Kinematic viscosity";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real Pr = 0.71 "Prandtl Number";
parameter Real Beta(unit = "K^-1") = 333 "coefficient of Expansion ";
parameter Real k(unit = "W/m.K") = 0.0279"Thermal conductivity";
parameter Real L(unit  = "m") = 1 "length along the shaft";

//=========================================================================
//Library section
extends Modelica.Constants;

//==========================================================================
//Equation section
equation
w = (rpm*2*pi)/60;
Re = (pi*(d^2)*w)/V;
Ra = (g*(Tc-Ta)*(d^3)*Pr)/(Beta*(V^2));
Nu = 0.11*(((0.5*(Re^2))+Ra)^0.35);
hc = (Nu*k)/d;
q = (hc*pi*d*L*(Tc-Ta));


end Ex5_6;