//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-06,Forced convection inside tubes and ducts
//Exercise: 6.3, Page No: 375
//Title: Ducts of non-circular cross-section
//===================================================
class Ex6_3
//Variable section
Real D_H(unit = "m") "Hydraulic diameter";
Real Re_D_H "Reynolds number";
Real hc(unit = "W/m2.K") "Heat transfer coefficient";
Real f "Friction factor";
//=====================================================
//Parameter section
parameter Real u(unit = "m/s") = 0.03 "Velocity";
parameter Real l(unit = "m") = 0.1 "Length";
parameter Real b(unit = "m") = 0.1 "Breadth";
parameter Real rho(unit = "Kg/m3") = 810 "Density";
parameter Real mu(unit = "N.s/m2") = 29.5e-4 "Dynamic viscosity";
parameter Real k(unit = "W/m.K") = 0.167 "Thermal conductivity";
parameter Real Nu_D_H = 2.98 "Nusselt number taken from table 6.1";
//=====================================================
//Equation section
equation
D_H = (4*(l*b))/(4*l);
Re_D_H = ((rho*u*D_H)/mu);
hc = (Nu_D_H*k)/D_H;
f = 56.91/Re_D_H;
//Re_D_H*f = 56.91 is taken from table 6.1
//======================================================
end Ex6_3;