//========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 13, Exercise - 1.2
//Title: Plane walls
//========================================================================

class Ex1_2
//Variable section
//=========================================================================
Real Rk(unit = "K/W") "Thermal resistance";
Real qk(unit = "W") "Rate of heat loss from the interior to the exterior surface";

//=========================================================================
//Parameter Section 
parameter Real L(unit = "m") = 0.005 "Length";
parameter Real k(unit = "W/m.K") = 0.81 "Thermal conductivity";
parameter Real H(unit = "m") = 1 "Height";
parameter Real W(unit = "m") = 0.5 "Width";
parameter Real T1(unit = "deg.C") = 24.5 "Inner surface temperature";
parameter Real T2(unit = "deg.C") = 24 "Outer surface temperature";

//=========================================================================
//Equation Section
equation
Rk = (L/(k*H*W));
qk = (T1 - T2)/Rk;

//=========================================================================

end Ex1_2;