
//========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 20, Exercise - 1.3
//Title: Convection
//========================================================================

class Ex1_3
//Variable section
//=========================================================================
Real Area(unit = "m2") "Area of roof";
Real qc(unit = "W") "Rate of heat transfer by convection from the air to the roof";

//=========================================================================
//Parameter Section
parameter Real L(unit = "m") = 20 "Length of roof";
parameter Real W(unit = "m") = 20 "Width of roof";
parameter Real hc(unit = "W/m2.K") = 10 "Heat transfer coefficient";
parameter Real T_air(unit = "deg.C") = -3 "Temperature of air";
parameter Real T_roof(unit = "deg.C") = 27 "Roof temperature";


//=========================================================================
//Equation Section
equation

Area = L*W;
qc = Area*hc*(T_air - T_roof);

//=========================================================================


end Ex1_3;