//========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 26, Exercise - 1.5
//Title: Plane walls in series and parallel
//========================================================================

class Ex1_5
//Variable section
//=========================================================================
Real qk_A(unit = "W/m2") "Rate of heat loss per unit area";
Real T_2(unit = "K") "Interface temperature";

//=========================================================================
//Parameter Section
parameter Real T1(unit = "K") = 900 "Inner surface temperature";
parameter Real To(unit = "K") = 460 "Outer surface temperature";
parameter Real L1(unit = "m") = 0.005 "Thickness of steel";
parameter Real L2(unit = "m") = 0.1 "Thickness of Zirconium brick";
parameter Real k1(unit = "W/m.K") = 40 " Thermal conductivity of steel";
parameter Real k2(unit = "W/m.K") = 2.5 " Thermal conductivity of Zirconium brick";


//=========================================================================
//Equation Section
equation
qk_A = ((T1 - To)/((L1/k1) + (L2/k2)));
T_2 = T1 - (qk_A*(L1/k1));

//=========================================================================

end Ex1_5;