//==========================================================================
//Calculated delT_x value in OpenModelica is as such taken to calculate q and q1 whereas in textbook del_x value is rounded of and calculated q and q1 value due to which their is small deviation in q and q1 value from textbook answer
//==========================================================================

//==========================================================================
//Chapter-10, Heat transfer with phase change 
//Page No.: 643 , Exercise - 10.1
//Title: Nucleate pool boiling
//==========================================================================

model Ex10_1
//==========================================================================
//Variable section
Real delT_x(unit = "deg.C") "Temperature difference";
Real q(unit = "W/m2") "Heat flux";
Real q_max_z(unit = "W/m2") "Critical heat flux";
Real q1(unit = "W/m2") "Heat flux from the surface to the water when the T_surface is 106 deg.C";

//==========================================================================
//Parameter section
parameter Real gc(unit = "m/s2") = 1;
parameter Real g(unit = "m/s2") = 9.8 "Acceleration due to gravity";
parameter Real rho_l(unit = "Kg/m3") = 962 "Denstiy of liquid";
parameter Real rho_v(unit = "Kg/m3") = 0.6 "Density of vapour";
parameter Real T_1(unit = "deg.C") = 106 "Surface temperature";
parameter Real T_2(unit = "deg.C") = 100 "Surface temperature";
parameter Real mu_l(unit = "Kg/m.s") = 2.77e-4 "Viscosity of liquid";
parameter Real Pr_l = 1.75 "Prandtl number of liquid";
parameter Real hfg(unit = "J/g") = 2.25e6 "Enthalpy";
parameter Real sigma(unit = "N/m") = 58.8e-3 "Surface tension";
//sigma is taken from table 10.2 at 100 deg.C
parameter Real Csf = 0.0132;
parameter Real C1(unit = "J/Kg.degC") = 4211;
//Data is taken from Appendix 2 table 13 

//==========================================================================
//Library section
extends Modelica.Constants;


//==========================================================================
//Equation section
equation 
delT_x = T_1 - T_2;
q = (((C1*delT_x)/(Csf*hfg*Pr_l))^3)* mu_l*hfg * (sqrt((g*(rho_l - rho_v))/(gc*sigma)));
q_max_z = (pi/24)*(rho_v^(1/2))*hfg*((sigma*g*(rho_l - rho_v)*gc)^(1/4));
q1 = 29669*((Csf/0.0058)^3);

//==========================================================================

end Ex10_1;