//==========================================================================
//Chapter-10, Heat transfer with phase change 
//Page No.: 666 , Exercise - 10.4
//Title: Condensation
//==========================================================================

package Ex10_4
  class Ex10_4_a
  //==========================================================================
  //Variable section
  Real T_avg(unit = "K") "Average temperature";
  Real hc(unit = "W/m2.K") "Heat transfer coefficient of tube in horizontal position";
  
  
  //==========================================================================
  //Parameter section
  parameter Real D(unit = "m") = 0.013 "Diameter";
  parameter Real Tsv(unit = "K") = 349 "Temperature";
  parameter Real Ts(unit = "K") = 325 "Surrounding temperature";
  parameter Real sigma(unit = "N/m") = 58.8e-3 "Surface tension";
  parameter Real Kl(unit = "W/m.K") = 0.661 "Thermal conductivity";
  parameter Real Cpl(unit = "J/Kg.K") = 4184 "Specific heat";
  parameter Real mu_l(unit = "N.s/m2") = 4.48e-4 "Viscosity of vapour";
  parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
  parameter Real rho_l(unit = "Kg/m3") = 980.9 "Density of liquid";
  parameter Real rho_v(unit = "Kg/m3") = 0.25 "Density of vapour";
  parameter Real hfg(unit = "J/Kg") = 2.417e6 "Enthalpy";
  
  
  //==========================================================================
  //Equation section
  equation
  
  T_avg = (Tsv + Ts)/2;
  hc = (0.725*((((rho_l*(rho_l - rho_v)*g*hfg*(Kl^3))/(D*mu_l*(Tsv - Ts))))^(1/4)))/1000;
  
  //==========================================================================
  end Ex10_4_a;

  class Ex10_4_b
  //==========================================================================
  //Variable section
  Real hc(unit = "W/m2.K") "Heat transfer coefficient of tube in vertical position";
  
  //==========================================================================
  //Parameter section
  parameter Real L(unit = "m") = 1.5 "Diameter";
  parameter Real Tsv(unit = "K") = 349 "Temperature";
  parameter Real Ts(unit = "K") = 325 "Surrounding temperature";
  parameter Real sigma(unit = "N/m") = 58.8e-3 "Surface tension";
  parameter Real Kl(unit = "W/m.K") = 0.661 "Thermal conductivity";
  parameter Real Cpl(unit = "J/Kg.K") = 4184 "Specific heat";
  parameter Real mu_l(unit = "N.s/m2") = 4.48e-4 "Viscosity of vapour";
  parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
  parameter Real rho_l(unit = "Kg/m3") = 980.9 "Density of liquid";
  parameter Real rho_v(unit = "Kg/m3") = 0.25 "Density of vapour";
  parameter Real hfg(unit = "J/Kg") = 2.417e6 "Enthalpy";
  
  
  //==========================================================================
  //Equation section
  equation
  
  hc = (0.943*(((rho_l*(rho_l - rho_v)*g*hfg*(Kl^3))/(mu_l*L*(Tsv - Ts)))^(1/4)));
  
  //==========================================================================
  
  end Ex10_4_b;
end Ex10_4;
