//==========================================================================
//Chapter-10, Heat transfer with phase change 
//Page No.: 667 , Exercise - 10.5
//Title: Film-wise Condensation
//==========================================================================
model Ex10_5

//==========================================================================
//Variable section
Real Re "Reynolds number";

//==========================================================================
//Parameter section
parameter Real D(unit = "m") = 0.013 "Diameter";
parameter Real L(unit = "m") = 1.5 "Length";
parameter Real Tsv(unit = "K") = 349 "Temperature";
parameter Real Ts(unit = "K") = 325 "Surrounding temperature";
parameter Real sigma(unit = "N/m") = 58.8e-3 "Surface tension";
parameter Real Kl(unit = "W/m.K") = 0.661 "Thermal conductivity";
parameter Real Cpl(unit = "J/Kg.K") = 4184 "Specific heat";
parameter Real mu_l(unit = "N.s/m2") = 4.48e-4 "Viscosity of vapour";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real rho_l(unit = "Kg/m3") = 980.9 "Density of liquid";
parameter Real rho_v(unit = "Kg/m3") = 0.25 "Density of vapour";
parameter Real hfg(unit = "J/Kg") = 2.417e6 "Enthalpy";


//==========================================================================
//Equation section
equation
Re = (4/3)*((((rho_l^(2/3))*4*Kl*L*(Tsv - Ts)*(g^(1/3)))/((mu_l^(5/3))*hfg))^(3/4));

//==========================================================================
end Ex10_5;