//=========================================================================
//Their is slight difference between Textbook and open modelica answer because in textbook answer is being rounded off and calculated.
//=========================================================================

//=========================================================================
//Chapter-02, Heat Conduction
//Page No.: 89, Exercise - 2.4
//Title : Steady state conduction in simple geomentries
//=========================================================================
model Ex2_4
//=========================================================================
//Variable section
Real R3(unit = "K/W") "Interior surface resistance";
Real R4(unit = "K/W") "Interior surface resistance";
Real q(unit = "W") " Rate of heat transfer from ambient air to nitrogen in the container";
Real m(unit = "Kg/hr") "Mass flowrate";

//=========================================================================
//Parameter Section
parameter Real ro(unit = "m") = 0.275 "Outer diameter";
parameter Real ri(unit = "m") = 0.25 "Inner diameter";
parameter Real k(unit = "W/m.K") = 0.0017 "Thermal conductivity";
parameter Real hco(unit = "W/m2.K") = 20 "Convective heat transfer coefficient at outer surface";
parameter Real T_air(unit = "deg.C") = 300 "Air temperature";
parameter Real T_Nitrogen(unit = "deg.C") = 77 "Nitrogen temperature";
parameter Real hfg(unit = "J/Kg") = 2e5 "Enthalpy";

//=========================================================================
//Library section
extends Modelica.Constants;

//=========================================================================
//Equation Section
equation
R3 = 1/(hco*4*pi*(ro^2));
R4 = ((ro - ri)/(4*pi*k*ro*ri));
q = ((T_air - T_Nitrogen)/(R3 + R4));
m = (q*3600)/hfg;
//=========================================================================

end Ex2_4;