//=========================================================================
//Chapter-02, Heat Conduction
//Page No.: 115, Exercise - 2.9
//Title : Multi dimensional Steady conduction //=========================================================================
class Ex2_9
//=========================================================================
//Variable section
Real S1(unit = "m") "Shape factor for walls";
Real S2(unit = "m") "Shape factor for edges";
Real S3(unit = "m") "Shape factor for corners";
Real S_Total(unit = "m") "Total Shape factor";
Real q(unit = "kW") "Heat flow";

//=========================================================================
//Parameter Section
parameter Real L(unit = "m") = 0.1 "Length";
parameter Real D(unit = "m") = 0.5 "Diameter";
parameter Real k(unit = "W/m.K") = 1.04 "Thermal conductivity";
parameter Real T1(unit = "deg.C") = 500 "Temperature";
parameter Real T2(unit = "deg.C") = 50 "Temperature";

//=========================================================================
//Equation Section
equation
S1 = ((D^2)/L);
S2 = 0.54*D;
S3 = 0.15*L;
S_Total = ((6*S1) + (12*S2) + (8*S3));
q = (k*S_Total*(T1 - T2))/1000;
//=========================================================================

end Ex2_9;