//=========================================================================
//Chapter-05, Natural Convection
//Page No: 303, Exercise -5.1
//Title : Similarity Parameters for Natural Convection
//=========================================================================

model Ex5_1

//Variable section
//=========================================================================
Real q(unit= "W/m") "Rate of  convection heat loss  in Room air per unit length in W/m";
Real hc(unit= "W/m2.K") "Heat transfer coefficent in Carbon Dioxide Atmosphere in W/m2";
Real RaD "Rayleigh Number";
Real Beta(unit = "K-1") "Coefficient of Expansion";

//==========================================================================
//Parameter section
parameter Real D(unit = "m") = 0.001 "diameter of wire";
parameter Real Pr = 0.71 "Prandtl Number";
parameter Real T(unit = "K") = 127 " Wire Temperature";
parameter Real TR(unit = "K") = 27 " Room Temperature";
parameter Real KV(unit = "m2/s") = 2.12e-5 "Kinematic viscosity";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real NuD = 1.32 "Nusselt number";
parameter Real k(unit = "W/m.K") = 0.0291 "Thermal conductivity";
parameter Real T_beta(unit = "K") = 350 "Temperature";
//from fig 5.3 calcualte NuR and k

//==========================================================================
//Library section
extends Modelica.Constants;

//==========================================================================
//Equation section
equation
Beta = 1/T_beta;
RaD = Pr*((g*Beta*(T-TR)*(D^3))/(KV^2));
hc = (NuD*k)/D;
q = hc*(T-TR)*pi*D;
//==========================================================================


end Ex5_1;