//========================================================================
//Calculated hc and Nu value in OpenModelica is as such taken to calculate q whereas in textbook hc and Nu value is rounded of and calculated q value due to which their is small deviation in q value from textbook answer
//========================================================================
//==========================================================================
//Chapter-05, Natural Convection
//Page No: 319, Exercise - 5.5
//Title : Enclosed Spaces
//=========================================================================

model Ex5_5

//Variable section
//=========================================================================

Real Ra "Rayleigh number";
Real hc(unit= "W/m2.K") "Heat transfer coefficent for convection ";
Real Nu" Nusselt number";
Real q(unit ="W") "rate of heat transfer";


//==========================================================================
//Parameter section
parameter Real Tb(unit = "deg.C") = 100 "Bottom temperature";
parameter Real Tr(unit = "deg.C") = 20 "Room temperature";
parameter Real L(unit = "m") = 0.08 "height of water in pan";
parameter Real d (unit ="m")=  0.15 "diameter of pan";
parameter Real V(unit = "m2/s") = 0.478e-6 "Kinematic viscosity";
parameter Real g(unit = "m/s2") = 9.8 "acceleration due to gravity";
parameter Real Pr = 3.02 "Prandtl Number";
parameter Real Beta(unit = "K^-1") = 5.18e-4 "coefficient of Expansion ";
parameter Real k(unit = "W/m.K") = 0.657"Thermal conductivity";

//=========================================================================
//Library section
extends Modelica.Math;
extends Modelica.Constants;

//=========================================================================
//Equation section
equation
Ra = (g*Beta*(Tb-Tr)*(L^3)*Pr)/(V^2);
Nu = 1+(1.44*(1-(1708/Ra)))+(((Ra/5830)^(1/3))-1)+2*(((Ra^(1/3))/140)^(1-(log((Ra^(1/3))/140))));
hc = (Nu*k)/L;
q = (hc*pi*(d^2)*(Tb-Tr))/4;



end Ex5_5;