//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-06,Forced convection inside tubes and ducts
//Exercise: 6.6, Page No: 394
//Title: Liquid metals
//===================================================
class Ex6_6
//Variable section
Real Re_D "Reynolds number";
Real hc(unit = "W/m2.K") "Heat transfer coefficient";
Real A(unit = "m2") "Area";
Real Area(unit = "m2") "Area";
Real L(unit = "m") "Required length";
//=====================================================
//Parameter section
parameter Real m(unit = "Kg/s") = 3 "Mass flowrate";
parameter Real D(unit = "m") = 0.05 "Diameter";
parameter Real rho(unit = "Kg/m3") = 7700 "Density";
parameter Real Pr = 0.011 "Prandtl number";
parameter Real v(unit = "m2/s") = 8e-8 "Kinematic viscosity";
parameter Real k(unit = "W/m.K") = 12 "Thermal conductivity";
parameter Real q(unit = "W") = 390 "Heat load";
parameter Real delT(unit = "K") = 30 "Temperature difference";
//=====================================================
//Library section
extends Modelica.Constants;
//=====================================================
//Equation section
equation
A = (pi*(D^2)/4);
Re_D = ((m*D)/(rho*v*A));
hc = (k/D)*0.625*((Re_D*Pr)^0.4);
Area = (q/(hc*delT));
L = (Area/(pi*D));
//======================================================
end Ex6_6;