//==========================================================================
//Dp answer in textbook is wrong. So, answer ReDp calculated using Dp in openmodelica is having deviation from textbook answer 
//==========================================================================

//==========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 442 , Exercise - 7.4
//Title: Packed beds
//==========================================================================
model Ex7_4
//==========================================================================
//Variable section
Real U_s(unit = "m/hr") "Superficial velocity";
Real Vc(unit = "m3") "Cylindrical packing volume";
Real As(unit = "m2") "Surface area";
Real Dp(unit = "cm") "Equivalent packing diameter";
Real ReDp "Reynolds number";
Real hc(unit = "W/m2.deg.C") "Heat transfer coefficient";


//==========================================================================
//Parameter section
parameter Real m(unit = "Kg/h") = 5 "Flowrate of CO2";
parameter Real L(unit = "cm") = 1.17 "Length of solid cylinder";
parameter Real KV(unit = "m2/s") = 4.82e-5 "Kinematic viscosity";
parameter Real Pr = 0.71 "Prandtl number";
parameter Real rho(unit = "Kg/m3") = 0.6 "Density";
parameter Real D(unit = "cm") = 0.93 "Diameter of solid cylinder";
parameter Real k(unit = "W/m.deg.C") = 0.042 "Thermal conductivity";
parameter Real D_1(unit = "m") = 0.0762 "Diameter";

//==========================================================================
//Library section 
extends Modelica.Constants;

//==========================================================================
//Equation section
equation
U_s = ((4*m)/(rho*(pi*(D_1^2))));
Vc = (((pi*(D^2))/4)*L);
As = (2*((pi*(D^2))/4))+(pi*D*L);
Dp = (6*Vc)/As;
ReDp = ((U_s*(Dp/100))/(3600*KV));
hc = (((0.094*(ReDp^0.8)*(Pr^0.4))+(2.58*(ReDp^(1/3))*(Pr^(1/3))))*k*100)/Dp;

//==========================================================================


end Ex7_4;