
//==========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 470 , Exercise - 7.8
//Title: Submerged jets - Heat transfer correlations
//==========================================================================

model Ex7_8
//==========================================================================
//Variable section
Real Re_w "Reynolds number";
Real m;
Real Nu_w "Nusselt number";
Real hc(unit = "W/m2.deg.C") "Heat transfer coefficient";
Real q(unit = "W") "Heat transfer rate from the 4 cm wide region of the plate directly below the jet";


//==========================================================================
//Parameter section
parameter Real u(unit = "m/s") = 10 "Velocity of air";
parameter Real rho(unit = "Kg/m3") = 1.092 "Density of air";
parameter Real mu(unit = "N.s/m2") = 1.912e-5 "Dynamic viscosity";
parameter Real Pr = 0.71 "Prandtl number";
parameter Real w(unit = "m") = 0.003 "Width of nozzle";
parameter Real k(unit = "W/m.K") = 0.0265 "Thermal conductivity";
parameter Real x(unit = "m") = 0.02;
parameter Real zo(unit = "m") = 0.01;
parameter Real T2(unit = "deg.C") = 60 "Final temperature";
parameter Real T1(unit = "deg.C") = 20 "Intial temperature";
parameter Real w_1(unit = "m") = 0.04 "Width";

//==========================================================================
//Equation section
equation
Re_w = ((rho*u*w)/mu);
m = 0.695 - 2*(((x/w) + 0.796*((zo/w)^1.33) + 6.12)^(-1));
Nu_w = ((1.53*((2*Re_w)^m)*(Pr^0.42))/((x/w)+(zo/w)+2.78));
hc = Nu_w*k/w;
q = hc*x*(T2 - T1)*w_1;

//==========================================================================

end Ex7_8;