//==========================================================================
//Chapter-08, Heat Exchangers 
//Page No.: 515 , Exercise - 8.4
//Title: Heat Exchanger effectiveness
//==========================================================================

model Ex8_4
//==========================================================================
//Variable section
Real e "Effectiveness";
Real Ud(unit = "Btu/hr.ft2.deg.F") "Overall design heat-transfer coefficient per unit outside area of tube";
Real L(unit = "ft") "Length of the tube";


//==========================================================================
//Parameter section
parameter Real Tc_out(unit = "deg.F") = 110 "Cold outlet temperature";
parameter Real Tc_in(unit = "deg.F") = 60 "Cold inlet temperature";
parameter Real Th_in(unit = "deg.F") = 125.4 "Hot inlet temperature";
parameter Real Th_out(unit = "deg.F") = 125.4 "Hot outlet temperature";
parameter Real ho(unit = "Btu/hr.ft2.deg.F") = 600 "Heat transfer coefficient at the steam side";
parameter Real hi(unit = "Btu/hr.ft2.deg.F") = 300 "Heat transfer coefficient at the water side";
parameter Real Rd(unit = "hr.ft2.deg.F/Btu") = 0.0005 "Fouling factor";
parameter Real m(unit = "lb/hr") = 25000 "Mass flowrate of sea water";
parameter Real Do(unit = "in") = 1.125 "Outer diameter";
parameter Real Di(unit = "in") = 0.995 "Inner diameter";
parameter Real N = 60 "No of parallel tubes";
parameter Real NTU = 1.4 "Number of transfer units";

//=========================================================================
//Library section
extends Modelica.Constants;


//=========================================================================
//Equation section
equation
e = (Tc_out - Tc_in)/(Th_in - Tc_in);
Ud = 1/((1/ho)+Rd+((Do/(2*12*N))*log(Do/Di))+((Rd*Do)/Di)+(Do/(hi*Di)));
L = ((NTU*m*Di*12)/(N*pi*Do*Ud));

//=========================================================================


end Ex8_4;