//=========================================================================
//Chapter-09, Heat Transfer by Radiation
//Page No.:590 , Exercise - 9.11
//Title: Enclosures With Gray Surfaces
//=========================================================================

model Ex9_11

//Variable section
//=========================================================================
Real q1(unit = "Btu/h") "Rate of heat flow by Radiation to the oxygen in the container";
Real T1(unit = "R") "Inner Sphere Temperature";
Real T2(unit = "R") "Outer Sphere Temperature";
//=========================================================================
//Parameter Section
parameter Real epsilon1 = 0.03;
parameter Real epsilon2 = 0.03;
parameter Real  A1(unit ="ft2") = 1 "Inner Diameter";
parameter Real  A2(unit ="ft2") = 2.25 "Outer Diameter";
parameter Real sigma(unit = "Btu/h.ft2.R4") = 0.1714e-8 "Stefan-Boltzman constant";
parameter Real T_2(unit = "F") = 30 "Inner Sphere Temperature";
parameter Real T_1(unit = "F") = -297 "Outer Sphere Temperature";

//=========================================================================
//Library section
extends Modelica.Constants;

//=========================================================================
//Equation Section
equation
T1 = 460 + T_1;
T2 = 460 + T_2;
q1 = (pi*sigma*((T1^4) - (T2^4)))/((1/epsilon1)+((A1/A2)*((1 - epsilon2)/epsilon2)));

//=========================================================================
end Ex9_11;