
//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 49, Exercise - 1.12
//Title : Thermal insulation
//=========================================================================

class Ex1_12
//=========================================================================
//Variable section
Real R(unit = "m2.K/W") "Thermal resistance of the tw ometal sheets";
Real del_T(unit = "K") "Temperature difference";
Real del_T1(unit = "K") "Temperature difference";
Real del_T2(unit = "K") "Delta T across insulation";
Real L(unit = "m") "Insulation thickness";


//=========================================================================
//Parameter Section
parameter Real L1(unit = "in") = 0.625 "Length";
parameter Real k(unit = "W/m.K") = 43 "Thermal conductivity";
parameter Real q_A(unit = "W/m2") = 1200 "Heat loss";
parameter Real U(unit = "W/m2.K") = 20 "Overall heat transfer coefficient between the glass and the door";
parameter Real U_1(unit = "W/m2.K") = 5 "Overall heat transfer coefficient between the surface of the door and the surroundings";
parameter Real T(unit = "deg.C") = 20 "Surrounding temperature";
parameter Real T_1(unit = "deg.C") = 1200 "Gas temperature inside the furnace";
parameter Real k1(unit = "W/m.K") = 0.27 "Thermal conductivity";


//=========================================================================
//Equation Section
equation
R = L1/(k*39.4);
del_T = q_A/U;
del_T1 = q_A/U_1;
del_T2 = ((T_1 - T) - (del_T +del_T1));
L = (k*del_T2)/q_A;


//=========================================================================

end Ex1_12;