//===========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 53, Exercise - 1.13
//Title : Conservation of energy applied to heat transfer analysis
//===========================================================================

package Ex1_13
  class Ex1_13_a
  //=========================================================================
  //Variable section
  Real T_roof(unit = "K") "Roof equilibrium temperature in K";
  Real T_roof_1(unit = "deg.C") "Roof equilibrium temperature in deg.C";
  
  
  //=========================================================================
  //Parameter Section
  parameter Real hc(unit = "W/m2.K") = 10 "Heat transfer coefficient";
  parameter Real q_A1(unit = "W/m2") = 500 "Incident solar radiation flux";
  parameter Real T_air(unit = "K") = 300 "Ambient air temperature";
  parameter Real T_sky(unit = "K") = 50 "Sky temperature";
  parameter Real Sigma(unit = "W/m2.K4") = 5.67e-8 "Stefans Boltzman constant";
  
  
  //=========================================================================
  //Equation Section
  equation
  ((hc * (T_air - T_roof)) + (q_A1)) = Sigma * ((T_roof^4) - (T_sky^4));
  T_roof_1 = T_roof - 273.15; 
  
  end Ex1_13_a;

  class Ex1_13_b
  //=========================================================================
  //Variable section
  Real T_roof(unit = "K") "Roof equilibrium temperature in K";
  Real T_roof_1(unit = "deg.C") "Roof equilibrium temperature in deg.C";
  
  //=========================================================================
  //Parameter Section
  parameter Real hc(unit = "W/m2.K") = 10 "Heat transfer coefficient";
  parameter Real T_air(unit = "K") = 300 "Ambient air temperature";
  parameter Real T_sky(unit = "K") = 50 "Sky temperature";
  parameter Real Sigma(unit = "W/m2.K4") = 5.67e-8 "Stefans Boltzman constant";
  
  
  //=========================================================================
  //Equation Section
  equation
  hc * (T_air - T_roof) = Sigma * ((T_roof^4) - (T_sky^4));
  T_roof_1 = T_roof - 273.15; 
  
  //=========================================================================
  
  end Ex1_13_b;
end Ex1_13;
