//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 22, Exercise - 1.4
//Title: Radiation
//=========================================================================

class Ex1_4
//Variable section
//=========================================================================
Real qr(unit = "W") "The net heat loss from the rod of the surface";
Real hr(unit = "W/m2.K") "Radiation heat transfer coefficient";


//=========================================================================
//Parameter Section
parameter Real epsilon = 0.9;
parameter Real D(unit = "m") = 0.02 "Diameter";
parameter Real L(unit ="m") = 1 "Height";
parameter Real sigma(unit = "W/m2.K4") = 5.67e-8 "Stefan-Boltzman constant";
parameter Real T_1(unit = "K") = 1000 "Temperature of heating rod";
parameter Real T_2(unit = "K") = 800 "Temperature of interior walls of furnace";

//=========================================================================
//Library section
extends Modelica.Constants;


//=========================================================================
//Equation Section
equation
qr = pi*D*L*epsilon*sigma*((T_1^4) - (T_2^4));
hr = (epsilon*sigma*((T_1^4) - (T_2^4)))/(T_1 - T_2);

end Ex1_4;