//=========================================================================
//Chapter-01, Basics of heat transfer
//Page No.: 37, Exercise - 1.9
//Title : Convection and conduction in series
//=========================================================================

//=========================================================================
class Ex1_9

//=========================================================================
//Variable section
Real R3(unit = "K/W") "Thermal resistance";
Real R2(unit = "K/W") "Thermal resistance";
Real R1(unit = "K/W") "Thermal resistance";
Real q_A(unit = "W") "Rate of heat transfer per unit area";


//=========================================================================
//Parameter Section
parameter Real k(unit = "W/m.K") = 0.7 "Thermal conductivity of brick wall";
parameter Real A(unit = "m2") = 1 "Area";
parameter Real hc_hot(unit = "W/m2.K") = 10 "Heat transfer coefficicent on hot side";
parameter Real hc_cold(unit = "W/m2.K") = 40 "Heat transfer coefficicent on cold side";
parameter Real T1(unit = "K") = 270 "Temperature of cold wind";
parameter Real T2(unit = "K") = 330 "Temperature of calm air";
parameter Real L(unit = "m") = 0.1 "Thickness of brick";

//=========================================================================
//Equation Section
equation
R1 = 1/(hc_hot*A);
R2 = L/(k*A);
R3 = 1/(hc_cold*A);
q_A = ((T2 - T1)/(R1 + R2 + R3));
//=========================================================================


end Ex1_9;