//========================================================================
//Chapter-02, Heat Conduction
//Page No.: 83, Exercise - 2.1
//Title : Plain wall with and without Heat generation

//=========================================================================
class Ex2_1
//=========================================================================
//Variable section
Real T_max_T1(unit = "deg.C") "Temperature difference between the center and the surface";
Real hc(unit = "W/m2.K") "Minimum heat transfer coefficient";


//=========================================================================
//Parameter Section
parameter Real L(unit = "m") = 0.01 "Length";
parameter Real L1(unit = "m") = 0.005 "Length";
parameter Real k(unit = "W/m.K") = 64 "Thermal conductivity";
parameter Real qG(unit = "W/m3") = 1000000 "Rate of Heat generated";
parameter Real T_infinity(unit = "deg.C") = 80 "Temperature of hot oil";
parameter Real T1(unit = "deg.C") = 200 "Temperature of heater";


//=========================================================================
//Equation Section
equation
T_max_T1 = ((qG*(L^2))/(8*k));
hc = ((qG*L1)/(T1 - T_infinity));


//=========================================================================

end Ex2_1;