//========================================================================
//Chapter-02, Heat Conduction
//Page No.: 84, Exercise - 2.2
//Title : Cylindrical and spherical spherical shapes without heat generation
//========================================================================

model Ex2_2

//=========================================================================
//Variable section
Real R1(unit = "mK/W") "Interior surface resistance";
Real R2(unit = "mK/W") "Interior surface resistance";
Real R3(unit = "mK/W") "Interior surface resistance";
Real R4(unit = "mK/W") "Interior surface resistance";
Real R0(unit = "mK/W") "Outer convection resistance";
Real R_Total(unit = "mK/W") "Total resistance";
Real q(unit = "W/m") "Heat loss";


//=========================================================================
//Parameter Section
parameter Real ri(unit = "m") = 0.05 "Inner radius";
parameter Real ro(unit = "m") = 0.06 "Outer radius";
parameter Real k_pipe(unit = "W/m.K") = 400 "Thermal conductivity of pipe";
parameter Real k1(unit = "W/m.K") = 0.2 "Thermal conductivity";
parameter Real hci(unit = "W/m2.K") = 10000 "Inner heat transfer coefficient";
parameter Real hco(unit = "W/m2.K") = 15 "Outer heat transfer coefficient";
parameter Real T_sat(unit = "deg.C") = 110 "Temperature of saturated steam flows inside the pipe";
parameter Real T_atm(unit = "deg.C") = 30 "Temperature of pipe located in space";
parameter Real ro_1(unit = "m") = 0.11 "Outer radius";


//=========================================================================
//Library section
extends Modelica.Constants;

//=========================================================================
//Equation Section
equation
R1 = 1/(2*pi*ri*hci);
R2 = ((log(ro/ri))/(2*pi*k_pipe));
R3 = 1/(2*pi*ro*hco);
R4 = ((log(ro_1/ri))/(2*pi*k1));
R0 = 1/(2*pi*ro_1*hco);
R_Total = R4 + R0;
q = (T_sat - T_atm)/R_Total;


end Ex2_2;