//=========================================================================
//Chapter-02, Heat Conduction
//Page No.: 88, Exercise - 2.3
//Title : Steady state conduction in simple geomentries
//=========================================================================
model Ex2_3
//=========================================================================
//Variable section
Real R1(unit = "m2.K/W") "Interior surface resistance";
Real R2(unit = "m2.K/W") "Interior surface resistance";
Real R3(unit = "m2.K/W") "Interior surface resistance";
Real Uo(unit = "W/m2.K") "Overall heat transfer coefficient";
Real q_L(unit = "W/m") " Heat loss per unit";


//=========================================================================
//Parameter Section
parameter Real ro(unit = "m") = 0.02 "Outer diameter";
parameter Real ri(unit = "m") = 0.015 "Inner diameter";
parameter Real k(unit = "W/m.K") = 0.5 "Thermal conductivity of plastic";
parameter Real hci(unit = "W/m2.K") = 300 "Convection heat transfer coefficient";
parameter Real hco(unit = "W/m2.K") = 10 "Heat transfer coefficient at outer surface";
parameter Real T_hot(unit = "deg.C") = 200 "Temperature on hot side";
parameter Real T_cold(unit = "deg.C") = 30 "Temperature on cold side";

//=========================================================================
//Library section
extends Modelica.Constants;

//=========================================================================
//Equation Section
equation
R1 = (ro/(ri*hci));
R2 = (ro*log(ro/ri))/k;
R3 = 1/hco;
Uo = 1/(R1 + R2 + R3);
q_L = (pi*2*ro*Uo*(T_hot - T_cold));
//=========================================================================

end Ex2_3;