//=====================================================
//Calculated Re_L value in OpenModelica is as such taken to calculate Nu_L whereas in textbook Re_L value is rounded of and calculated Nu_L and h_c value due to which their is small deviation in q_c,h_c and Nu_L value from textbook answer
//======================================================
//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-04, Analysis of convection heat transfer
//Exercise: 4.4, Page No: 276
//Title: Mixed boundary layer
//===================================================
class Ex4_4
//Variable section
Real Re_L "Reynolds number";
Real Nu_L "Nusselts number";
Real h_c(unit = "W/m2.K") "Average convection of heat transfer";
Real q_c(unit = "W") "Heat loss from the crankcase";
//=====================================================
//Parameter section
parameter Real rho(unit = "Kg/cm3") = 1.092 "Density of air at 313K";
parameter Real U_inf(unit = "m/s") = 30 "Road speed";
parameter Real L(unit = "m") = 0.6 "Length of crankcase";
parameter Real mu(unit = "cP") = 0.019123 "Viscosity of air at 313K";
parameter Real A(unit = "m2") = 0.28 "Surface area"; 
parameter Real k(unit = "W/m.K") = 0.0265 "Thermal conductivity";
parameter Real Pr = 0.71 "Prandtl number";
parameter Real T_s(unit = "K") = 350 "Temperature of crank case";
parameter Real T_inf(unit = "K") = 276 "Temperature of surrounding air";
//=====================================================
//Equation section
equation
Re_L = rho*U_inf*L/(mu*0.001);
//1000 is divided to convert cP to Pa.s
Nu_L = 0.036*(Pr^(1/3))*(Re_L^0.8);
h_c = Nu_L*k/L;
q_c = h_c*A*(T_s - T_inf);
//======================================================
end Ex4_4;