//==========================================================================
//Chapter-05, Natural Convection
//Page No: 307, Exercise -5.2
//Title : Similarity Parameters for Natural Convection
//=========================================================================

model Ex5_2
//Variable section
//=========================================================================

Real GrL "Grashoff Number if height is 15cm";
Real hc(unit= "W/m2.K") "Heat transfer coefficent for convection if heigth is 15cm";
Real q(unit= "W") "total dissipation rate if height is  15cm";



//==========================================================================
//Parameter section
parameter Real Ts(unit = "deg.C") = 130 "Surface temperature";
parameter Real Ta(unit = "deg.C") = 20 "ambient temperature";
parameter Real w(unit = "m") = 0.10 " width of plate";
parameter Real hR(unit = "W/m2.K") = 8.5 " heat transfer coefficent for radiation";
parameter Real k(unit = "W/m.K") = 2.9e-2 "Thermal conductivity";
parameter Real L(unit = "m") = 0.15 "Length";
parameter Real Nu = 35.7 "Nusselts number";

//==========================================================================
//Equation section
equation
GrL = 65*(1/(L^3))*(Ts - Ta);
hc = (Nu*k)/L;
q = (2*L*w*(hc+hR)*(Ts-Ta));

end Ex5_2;