//==========================================================================
//Chapter-05, Natural Convection
//Page No: 314, Exercise -5.4
//Title : Cylinders, Spheres, Cones, and Three-Dimensional Bodies
//==========================================================================

model Ex5_4

//Variable section
//=========================================================================

Real delta_Ta(unit= "deg.C") " temperature difference between pipe and air ";
Real T_pipe(unit = "deg.C") "temperature of the pipe";
Real delta_Tw(unit= "deg.C") " temperature difference between pipe and water ";


//==========================================================================
//Parameter section
parameter Real Ra = 1e9 "Rayleigh Number";
parameter Real Ta(unit = "deg.C") = 27 "ambient temperature";
parameter Real d (unit ="m")=  1 "diameter of pipe";
parameter Real Va(unit = "m2/s") = 1.64e-5 "Kinematic viscosity of air";
parameter Real Vw(unit = "m2/s") = 0.861e-6 "Kinematic viscosity of water";
parameter Real g(unit = "m/s2") = 9.8 "acceleration due to gravity";
parameter Real Pra = 0.71 "Prandtl Number";
parameter Real Prw = 5.9"Prandtl Number";
parameter Real Betaa(unit = "K^-1") = 300 "coefficient of Expansion for air";
parameter Real Betaw(unit = "K^-1") = 2.73e-4 "coefficient of Expansion for water";

//=========================================================================
//Equation section
equation
delta_Ta = (Ra*(Va^2)*Betaa)/(g*(d^3)*Pra);
T_pipe = delta_Ta +Ta;
delta_Tw = (Ra*(Vw^2))/(g*(d^3)*Prw*Betaw);

end Ex5_4;