//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-06,Forced convection inside tubes and ducts
//Exercise: 6.1, Page No: 365
//Title : Uniform heat flux
//===================================================
package Ex6_1
  class Ex6_1_a
  //Variable section
  Real Re_D "Reynolds number";
  //=====================================================
  //Parameter section
  parameter Real m(unit = "Kg/s") = 0.01 "Mass flowrate";
  parameter Real D(unit = "m") = 0.02 "Diameter";
  parameter Real mu(unit = "N.s/m2") = 910e-6 "Dynamic viscosity";
  //=====================================================
  //Library section
  extends.Modelica.Constants;
  //=====================================================
  //Equation section
  equation
  Re_D = ((4*m)/(mu*pi*D));
  //======================================================
  end Ex6_1_a;

  class Ex6_1_b
  //Variable section
  Real hc(unit = "W/m2.K") "Heat transfer coefficient";
  //=====================================================
  //Parameter section
  //parameter Real m(unit = "Kg/s") = 0.01 "Mass flowrate";
  parameter Real D(unit = "m") = 0.02 "Diameter";
  //parameter Real mu(unit = "N.s/m2") = 910e-6 "Dynamic viscosity";
  parameter Real k(unit = "W/m.K") = 0.608 "Thermal conductivity";
  //parameter Real Nu_D = 3.66 "Nusselt number";
  //parameter Real Del_T_out(unit = "deg.C") = 55;
  //parameter Real Del_T_in(unit = "deg.C") = 65;
  //parameter Real Cp(unit = "J/Kg.K") = 1964 "Specific heat";
  //parameter Real T_b_out(unit = "deg.C") = 45;
  //parameter Real T_b_in(unit = "deg.C") = 35;
  //=====================================================
  //Library section
  //extends.Modelica.Constants;
  //=====================================================
  //Equation section
  equation
  hc = 4.36*k/D;
  //qc = Cp*m*(T_b_out - T_b_in);
  //LMTD = ((Del_T_out - Del_T_in)/(log(Del_T_out/Del_T_in)));
  //L = qc/(pi*D*hc*LMTD);
  //======================================================
  end Ex6_1_b;

  class Ex6_1_c
  //Variable section
  Real L(unit = "m") "Length of pipe needed for a 30 deg.C increase in average temperature";
  //=====================================================
  //Parameter section
  parameter Real m(unit = "Kg/s") = 0.01 "Mass flowrate";
  parameter Real D(unit = "m") = 0.02 "Diameter";
  parameter Real k(unit = "W/m.K") = 0.608 "Thermal conductivity";
  parameter Real del_T(unit = "K") = 30 "Temperature difference";
  parameter Real Cp(unit = "J/Kg.K") = 4180 "Specific heat of water";
  parameter Real q(unit = "W/m2") = 15000 "Heat flux";
  //=====================================================
  //Library section
  extends.Modelica.Constants;
  //=====================================================
  //Equation section
  equation
  L = ((m*Cp*del_T)/(pi*D*q));
  //======================================================
  end Ex6_1_c;

  class Ex6_1_d
  //=====================================================
  //Variable section
  Real Ts(unit = "deg.c") "The inner tube surface temperature at the outlet";
  //=====================================================
  //Parameter section
  parameter Real T_b(unit = "deg.C") = 40 "Temperature difference";
  parameter Real qc(unit = "W/m2") = 15000 "Heat flux";
  parameter Real hc(unit = "W/m2.deg.C") = 132 "Heat transfer coeff";
  //=====================================================
  //Equation section
  equation
  Ts = ((qc/hc)+T_b);
  //======================================================
  end Ex6_1_d;

  class Ex6_1_e
  //Variable section
  Real f "Friction factor";
  //=====================================================
  //Parameter section
  parameter Real Re_D = 699 "Reynolds number";
  //=====================================================
  //Equation section
  equation
  f = (64/Re_D);
  //======================================================
  end Ex6_1_e;

  class Ex6_1_f
  //Variable section
  Real u(unit = "m/s") "Velocity";
  Real del_P(unit = "N/m2") "Pressure drop";
  //=====================================================
  //Parameter section
  parameter Real m(unit = "Kg/s") = 0.01 "Mass flowrate";
  parameter Real D(unit = "m") = 0.02 "Diameter";
  parameter Real rho(unit = "Kg/m3") = 997 "Density of water";
  parameter Real gc(unit = "Kg.m/N.s2") = 1 "Acceleraton due to gravity";
  parameter Real L(unit = "m") = 1.33 "Length of pipe needed for a 30 deg.C ncrease in average temperature";
  parameter Real f = 0.0915 "Friction factor";
  //=====================================================
  //Library section
  extends.Modelica.Constants;
  //=====================================================
  //Equation section
  equation
  u = (4*m)/(rho*pi*(D^2));
  del_P  = f*(L/D)*((rho*(u^2))/(2*gc));
  //=====================================================
  end Ex6_1_f;

  class Ex6_1_g
  //Variable section
  Real Pp(unit = "W") "Pumping power";
  //=====================================================
  //Parameter section
  parameter Real m(unit = "Kg/s") = 0.01 "Mass flowrate";
  parameter Real del_P(unit = "N/m2") = 3.1 "Pressure drop";
  parameter Real rho(unit = "Kg/m3") = 997 "Density of water";
  parameter Real eta_p = 0.5 ;
  //=====================================================
  //Equation section
  equation
  Pp = ((m*del_P)/(rho*eta_p));
  //=====================================================
  end Ex6_1_g;
end Ex6_1;
