//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-06,Forced convection inside tubes and ducts
//Exercise: 6.2, Page No: 370
//Title : Uniform surface temperature
//===================================================
class Ex6_2
//Variable section
Real Re_D "Reynolds number";
Real hc(unit = "W/m2.K") "Heat transfer coefficient";
Real qc(unit = "W") "Heat loss";
Real LMTD(unit = "K") "Logmean temperature difference";
Real L(unit = "m") "Length of the tube required";
//=====================================================
//Parameter section
parameter Real m(unit = "Kg/s") = 0.05 "Mass flowrate";
parameter Real D(unit = "m") = 0.01 "Diameter";
parameter Real mu(unit = "N.s/m2") = 0.210 "Dynamic viscosity";
parameter Real k(unit = "W/m.K") = 0.144 "Thermal conductivity";
parameter Real Nu_D = 3.66 "Nusselt number";
parameter Real Del_T_out(unit = "deg.C") = 55;
parameter Real Del_T_in(unit = "deg.C") = 65;
parameter Real Cp(unit = "J/Kg.K") = 1964 "Specific heat";
parameter Real T_b_out(unit = "deg.C") = 45;
parameter Real T_b_in(unit = "deg.C") = 35;
//=====================================================
//Library section
extends.Modelica.Constants;
extends.Modelica.Math;
//=====================================================
//Equation section
equation
Re_D = ((4*m)/(mu*pi*D));
hc = (Nu_D*k)/D;
qc = Cp*m*(T_b_out - T_b_in);
LMTD = ((Del_T_out - Del_T_in)/(log(Del_T_out/Del_T_in)));
L = qc/(pi*D*hc*LMTD);
//======================================================
end Ex6_2;