//======================================================
//Principles of heat transfer, 7th edition, Frank Kreith, Raj M. Manglik and Mark S. Bohn
//Chapter-06,Forced convection inside tubes and ducts
//Exercise: 6.7, Page No: 405
//Title: Forced convection cooling of electronic devices
//===================================================
class Ex6_7
//Variable section
Real Re_Hc "Reynolds number in integrated circuit";
Real Nu_6 "Nusselts number in sixth integrated circuit";
Real hc_2(unit = "W/m2.K") "Heat transfer coefficient in second integrated circuit";
Real hc_6(unit = "W/m2.K") "Heat transfer coefficient in sixth integrated circuit";
//=====================================================
//Parameter section
parameter Real Hc(unit = "m") = 0.017 "Spacing between the integrated circuits and adjacent printed circuit board";
parameter Real U(unit = "m/s") = 1.8 "Velocity";
parameter Real v(unit = "m2/s") = 15.7e-6 "Kinematic viscosity";
parameter Real Nu_2 = 29 "Nusselts number in second integrated circuit";
parameter Real L(unit = "m") = 0.027 "Length"; 
parameter Real k(unit = "W/m.K") = 0.0251 "Thermal conductivity";
//=====================================================
//Equation section
equation
Re_Hc = (U*Hc)/v;
hc_2 = (Nu_2*k)/L;
Nu_6 = (0.093*((Re_Hc)^0.72));
hc_6 = (Nu_6*k)/L;
//======================================================
end Ex6_7;