//=========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 429 , Exercise - 7.1
//Title: Cylinders, Spheres and other Bluff shapes
//=========================================================================

model Ex7_1


//=========================================================================
//Variable Section
Real hc(unit = "W/m2.deg.C") "Heat transfer coefficient";
Real hc_1(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 0 degrees";
Real hc_2(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 15 degrees";
Real hc_3(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 30 degrees";
Real hc_4(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 45 degrees";
Real hc_5(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 60 degrees";
Real hc_6(unit = "W/m2.deg.C") "Heat transfer coefficient at the stagnation point 75 degrees";

//=========================================================================
//Parameter Section
parameter Real rho(unit = "Kg/m3") = 0.566 "Density of air";
parameter Real mu(unit = "Kg/m.s") = 1.74e-5 "Viscosity of air";
parameter Real D(unit = "m") = 0.3 "Diameter of half cylinder";
parameter Real Pr = 0.72 "Prandtl number";
parameter Real U_infinity(unit ="m/s") = 150 "Velocity";
parameter Real k(unit = "W/m.K") = 0.024 "Thermal conductivity";
parameter Real teta_1(unit = "degrees") = 0 "Angle";
parameter Real teta_2(unit = "degrees") = 15 "Angle";
parameter Real teta_3(unit = "degrees") = 30 "Angle";
parameter Real teta_4(unit = "degrees") = 45 "Angle";
parameter Real teta_5(unit = "degrees") = 60 "Angle";
parameter Real teta_6(unit = "degrees") = 75 "Angle";

//=========================================================================
//Equation section
equation
hc = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(k/D);
hc_1 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_1/90)^3))*(k/D);
hc_2 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_2/90)^3))*(k/D);
hc_3 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_3/90)^3))*(k/D);
hc_4 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_4/90)^3))*(k/D);
hc_5 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_5/90)^3))*(k/D);
hc_6 = (1.14*(((rho*U_infinity*D)/mu)^0.5))*(Pr^0.4)*(1 - ((teta_6/90)^3))*(k/D);


//==========================================================================
end Ex7_1;