//==========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 434 , Exercise - 7.2
//Title: Hot water anemometer
//==========================================================================

model Ex7_3
//==========================================================================
//Variable section
Real ReL "Reynolds number";
Real hc(unit = "W/m2.deg.C") "Average heat transfer coefficient";
Real q(unit = "W") "Rate of heat loss from the array";


//==========================================================================
//Parameter section
parameter Real U_infinity(unit = "m/s") = 0.5 "Air velocity";
parameter Real L(unit = "m") = 2.5 "Length of each array";
parameter Real KV(unit = "m2/s") = 1.57e-5 "Kinematic viscosity";
parameter Real Pr = 0.71 "Prandtl number";
parameter Real rho(unit = "Kg/m3") = 1.16 "Density";
parameter Real cp(unit = "W s/Kg.K") = 1012 "Specific heat";
parameter Real T2(unit = "deg.C") = 70 "Surface temperature";
parameter Real T1(unit = "deg.C") = 20 "Ambient air temperature";

//==========================================================================
//Equation section
equation
ReL = (U_infinity*L)/KV;
hc = (0.930*((1/ReL)^(1/2))*((1/Pr)^(2/3))*cp*rho*U_infinity) ;
q = (hc*(L^2)*(T2 - T1));

//==========================================================================

end Ex7_3;