
//==========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 465 , Exercise - 7.6
//Title: Packed beds
//============================================================================

package Ex7_6
  class Ex7_6_a
  //==========================================================================
  //Variable section
  Real U_max(unit = "m/s") "Maximum Velocity";
  Real ReD "Reynolds number";
  Real NuD "Nusselts number";
  Real hc(unit = "W/m2.K") "Average heat transfer coefficient for the tube bank";
  Real hc_correction(unit = "W/m.K") "Corrected heat transfer coefficient";
  
  //==========================================================================
  //Parameter section
  parameter Real U(unit = "m/s") = 10 "Velocity";
  parameter Real KV(unit = "m2/s") = 16.27e-6 "Kinematic Viscosity";
  parameter Real D(unit = "m") = 0.04 "Diameter";
  parameter Real k(unit = "W/m.K") = 0.0332 "Thermal conductivity";
  parameter Real Pr = 0.73 "Prandtl number";
  parameter Real ST = 8;
  parameter Real SL = 6;
  
  
  //==========================================================================
  //Equation section
  equation
  U_max = 2*U;
  ReD = (U_max*D)/KV; 
  NuD = ((0.35*((ST/SL)^0.2))*(ReD^0.6)*(Pr^0.36));
  hc = (NuD*k)/D;
  hc_correction = 0.92*hc;
  
  
  end Ex7_6_a;

  class Ex7_6_b
  //==========================================================================
  //Variable section
  Real del_P(unit = "N/m2") "Pressure drop through the tube bank";
  
  //==========================================================================
  //Parameter section
  parameter Real U_max(unit = "m/s") = 20 "Maximum mass velocity";
  parameter Real rho(unit = "Kg/m3") = 0.668 "Density";
  parameter Real f = 0.25 "Friction factor";
  parameter Real gc(unit = "Kg.m/N.s2") = 1 "Gravitational force";
  parameter Real N = 5 "Number of rows";
  
  //==========================================================================
  //Equation section
  equation
  del_P = (N*f*rho*(U_max^2))/(2*gc);
  
  //==========================================================================
  
  end Ex7_6_b;
end Ex7_6;
