//==========================================================================
//Chapter-07, forced convection over exterior surfaces 
//Page No.: 465 , Exercise - 7.7
//Title: Free surface jets - Heat transfer calculations
//==========================================================================

package Ex7_7
  class Ex7_7_a
  //==========================================================================
  //Variable section
  Real ReD "Reynolds number";
  Real hc(unit = "W/m2.deg.C") "Heat transfer coefficient";
  Real Ts(unit = "deg.C") "Surface temperature at 3mm radial distance";
  
  
  //==========================================================================
  //Parameter section
  parameter Real m(unit = "Kg/s") = 0.008 "Flowrate";
  parameter Real mu(unit = "N.s/m2") = 993e-6 "Dynamic viscosity";
  parameter Real Pr = 7.0 "Prandtl number";
  parameter Real d(unit = "m") = 0.006 "Diameter of nozzle";
  parameter Real k(unit = "W/m.K") = 0.597 "Thermal conductivity";
  parameter Real T_j(unit = "deg.C") = 20 "Temperature of water jet";
  parameter Real q(unit = "W/m2") = 70000 "Heat flux";
  
  //==========================================================================
  //Library section
  extends Modelica.Constants;
  
  //==========================================================================
  //Equation section
  equation
  ReD = ((4*m)/(mu*pi*d));
  hc = (0.797*(ReD^0.5)*(Pr^(1/3))*k)/d;
  Ts = T_j + (q/hc);
  
  //==========================================================================
  end Ex7_7_a;

  class Ex7_7_b
  //==========================================================================
  //Variable section
  
  Real hc(unit = "W/m2.deg.C") "Heat transfer coefficient";
  Real Ts(unit = "deg.C") "Surface temperature at 3mm radial distance";
  
  
  //==========================================================================
  //Parameter section
  parameter Real ReD = 1709 "Reynolds number";
  parameter Real r(unit = "m") = 0.012 "Radius";
  parameter Real Pr = 7.0 "Prandtl number";
  parameter Real d(unit = "m") = 0.006 "Diameter of nozzle";
  parameter Real k(unit = "W/m.K") = 0.597 "Thermal conductivity";
  parameter Real T_j(unit = "deg.C") = 20 "Temperature of water jet";
  parameter Real q(unit = "W/m2") = 70000 "Heat flux";
  
  //==========================================================================
  //Equation section
  equation
  hc = (0.632*(ReD^0.5)*(Pr^(1/3))*((d/r)^0.5)*k)/d;
  Ts = T_j + (q/hc);
  //==========================================================================
  end Ex7_7_b;
end Ex7_7;
