//========================================================================
//Calculated delT_mean value in OpenModelica is as such taken to calculate U_A and U_A1 whereas in textbook delT_mean value is rounded of and calculated U_A and U_A1 value due to which their is small deviation in U_A and U_A1 value from textbook answer
//========================================================================
//==========================================================================
//Chapter-08, Heat Exchangers 
//Page No.: 510 , Exercise - 8.2
//Title: Heat Exchanger effectiveness
//=========================================================================

class Ex8_2
//==========================================================================
//Variable section
Real Cc(unit = "W/K") "Specific heat of cold fluid";
Real P "Mean Temperature for counterflow";
Real Z "Heat capacity rate ratio";
Real delT_a(unit = "K") "Temperature difference";
Real delT_b(unit = "K") "Temperature difference";
Real LMTD(unit = "K") "Logmean temperature difference";
Real delT_mean(unit = "K") "Mean temperature difference";
Real U_A(unit = "W/K") "Overall conductance";
Real U_A1(unit = "W/K") "Overall conductance";
Real NTU "No. of transfer units";
Real r "Ratio of specific heat";
Real T_oil_out(unit = "K") "Oil outlet temperature";


//==========================================================================
//Parameter section
parameter Real Tc_out(unit = "K") = 300 "Cold outlet temperature of water";
parameter Real Tc_in(unit = "K") = 290 "Cold inlet temperature";
parameter Real Th_in(unit = "K") = 340 "Hot inlet temperature";
parameter Real Th_out(unit = "K") = 310 "Hot outlet temperature";
parameter Real mh(unit = "Kg/s") = 1 "Mass flowrate";
parameter Real Ch(unit = "J/Kg.K") = 2100 "Specific heat of alcohol";
parameter Real F = 0.94;
//For calculated P and Z. F is taken from chart of Figure No.: 8.14, Page No.: 502
parameter Real u = 0.75 "Decrease in velocity to increase the thermal resistance";
parameter Real e = 0.61;
parameter Real T_oil_in(unit = "K") = 370 "Temperature of inlet oil";


//==========================================================================
//Library section
extends Modelica.Math;

//==========================================================================
//Equation section
equation
Cc = mh*Ch*((Th_in - Th_out)/(Tc_out - Tc_in));
P = ((Th_in - Th_out)/(Th_in - Tc_in));
Z = ((Tc_out - Tc_in)/(Th_in - Th_out));
delT_a = (Th_in - Tc_out);
delT_b = (Th_out - Tc_in);
LMTD = ((delT_a - delT_b)/(log(delT_a/delT_b)));
delT_mean = LMTD*F;
U_A = (mh*Ch*(Th_in - Th_out))/delT_mean;
U_A1 = U_A*(u^0.8);
NTU = U_A1/(u*mh*Ch);
r = (u*mh*Ch)/Cc;
T_oil_out = T_oil_in - (e*(T_oil_in - Tc_in));

//==========================================================================


end Ex8_2;