class Ex1_2
/*pressure conversion- 1 N/cm^2=10^4 N/m^2 */

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real T1_deg(unit="degC")=30;/*temperature at cross section 1 in degree celcius unit*/
Real T1(unit="K");/*temperature at cross section 1 in Kelvin unit*/
parameter Real p1_cm(unit="N/cm^2")=8;/*pressure at section 1 in N/cm^2 unit*/
Real p1(unit="N/m^2");/*pressure at section 1 in N/m^2 unit*/
Real rho1(unit="kg/m^3");/*density of gas at section 1*/
parameter Real V1(unit="m/s")=350;/*velocity of gas at section 1*/

parameter Real p2_cm(unit="N/cm^2")=12;/*gauge pressure at section 2 in N/cm^2 unit*/
Real p2(unit="N/m^2");/*absolute pressure at section 2 1 in N/m^2 unit*/
Real V2(unit="m/s");/*velocity of gas at section 2*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_deg);
p1=p1_cm*10^4;
p2=p2_cm*10^4;

(gama/(gama-1))*(p1/rho1)*(1-(p2/p1)^(1-(1/gama)))=(V2^2-V1^2)/2;
p1/rho1=R*T1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_2;
