class Ex1_4
/*pressure conversion- 1 atm=1.01*10^5 N/m^2 */

parameter Real A1(unit="m^2")=3;/*area of inlet*/
parameter Real A2(unit="m^2")=0.8;/*area of throat*/
parameter Real rho1(unit="kg/m^3")=1.225;/*density of air at inlet*/
parameter Real p2_atm(unit="atm")=1;/*pressure at throat in atm unit*/
Real p2(unit="N/m^2");/*pressure at throat in N/m^2 unit*/
parameter Real V2(unit="m/s")=50;/*velocity of gas at throat*/

Real V1(unit="m/s");/*velocity of gas at inlet*/
Real p1(unit="N/m^2");/*pressure at inlet*/

Real V2_2(unit="m/s");/*velocity of gas at throat at the condition of double pressure difference*/
equation
p2=p2_atm*1.01*10^5;
V1=V2*(A2/A1);

p1=p2+(rho1/2)*(V2^2-V1^2);

V2_2=sqrt((2*2*(p1-p2))/(rho1*(1-(A2/A1)^2)));
end Ex1_4;
