class Ex10_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real M_i(unit="kg")=5000;/*total mass*/
parameter Real M_L(unit="kg")=100;/*total pay load*/
parameter Real M_s(unit="kg")=800;/*total structural mass*/
parameter Real M_p(unit="kg")=4100;/*propellant mass*/
parameter Real I_s(unit="s")=360;/*specefic impulse*/

Real M_f(unit="kg");/*final mass*/
Real V_b(unit="m/s");/*burnout velocity*/

Real M_s1(unit="kg");/*structural mass after 1st stage*/
Real M_s2(unit="kg");/*structural mass after 2nd stage*/
Real M_p1(unit="kg");/*propellant mass for 1st stage*/
Real M_p2(unit="kg");/*propellant mass for 2nd stage*/
Real M_f1(unit="kg");/*final mass after 1st stage*/
Real V_b1(unit="m/s");/*burnout velocity after 1st stage*/
Real V_b2(unit="m/s");/*burnout velocity after 2nd stage*/
equation
M_f=M_s+M_L;
V_b=g*I_s*log(M_i/M_f);

M_s1=(3/5)*M_s;
M_s2=(2/5)*M_s;

M_p1=(3/5)*M_p;
M_p2=(2/5)*M_p;
M_f1=M_s1+M_p2+M_s2+M_L;
V_b1=g*I_s*log(M_i/M_f1);
V_b2-V_b1=g*I_s*log((M_p2+M_s2+M_L)/(M_s2+M_L));

/*the given value of M_p1 is wrong*/

end Ex10_3;
