class Ex2_12
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p0(unit="N/m^2")=250*10^3;/*total pressure of the air inside the tank*/
parameter Real T0_deg(unit="degC")=50;/*total temperature of the air inside the tank in degree celcius unit*/
Real T0(unit="K");/*total temperature of the air inside the tank in in Kelvin unit*/
Real rho0(unit="kg/m^3");/*density of the air inside the tank*/
 
parameter Real A1(unit="m^2")=0.025;/*area of the nozzle*/
parameter Real p1(unit="N/m^2")=100*10^3;/*static pressure at nozzle*/

parameter Real T_star_T0=0.833;/*ratio of temperature at sonic condition to total temperaure*/
parameter Real rho_star_rho0=0.634;/*ratio of density at sonic condition to total density*/
parameter Real p_star_p0=0.528;/*ratio of pressure at sonic condition to total pressure*/

Real C_star(unit="m/s");/*sonic velocity at throat*/
Real V_star(unit="m/s");/*velocity of the air at nozzle with sonic condition*/

Real T_star(unit="K");/*temperature at sonic condition*/
Real rho_star(unit="kg/m^3");/*dencity of the air at nozzle with sonic condition*/
Real p_star(unit="N/m^2");/*pressure of the air at nozzle with sonic condition*/
Real m_dot(unit="kg/s");/*mass flow rate through the nozzle*/
equation
T0=Modelica.SIunits.Conversions.from_degC(T0_deg);
rho0=p0/(R*T0);
T_star=T_star_T0*T0;
C_star=sqrt(gama*R*T_star);
V_star=C_star;
rho_star=rho_star_rho0*rho0;
m_dot=rho_star*A1*V_star;
p_star=p_star_p0*p0;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_12;
