class Ex2_13
parameter Real R(unit="J/kg.K")=117;/*specific gas constant*/
parameter Real gama=1.34;/*K-ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p0(unit="N/m^2")=290*10^3;/*total pressure of the chlorine inside the container*/
parameter Real T0_deg(unit="degC")=8;/*total temperature of the chlorine inside the container in degree celcius unit*/
Real T0(unit="K");/*total temperature of the chlorine inside the container in in Kelvin unit*/
Real rho0(unit="kg/m^3");/*density of the chlorine inside the container*/
 
parameter Real A1(unit="m^2")=0.12;/*area of the nozzle*/
parameter Real p1(unit="N/m^2")=120*10^3;/*pressure at receiver tank*/

parameter Real T_star_T0=0.833;/*ratio of temperature at choking condition to total temperaure*/
parameter Real rho_star_rho0=0.634;/*ratio of density at choking condition to total density*/
parameter Real p_star_p0=0.528;/*ratio of pressure at choking condition to total pressure*/

Real C_star(unit="m/s");/*choking velocity at nozzle*/
Real V_star(unit="m/s");/*velocity of the chlorine at nozzle with choking condition*/

Real T_star(unit="K");/*temperature at choking condition*/
Real rho_star(unit="kg/m^3");/*density of the chlorine at nozzle with choking condition*/
Real p_star(unit="N/m^2");/*pressure of the chlorine at nozzle with choking condition*/
Real m_dot(unit="kg/s");/*mass flow rate through the nozzle*/
equation
T0=Modelica.SIunits.Conversions.from_degC(T0_deg);
rho0=p0/(R*T0);
T_star=T_star_T0*T0;
C_star=sqrt(gama*R*T_star);
V_star=C_star;
rho_star=rho_star_rho0*rho0;
p_star=p_star_p0*p0;

m_dot=rho_star*A1*V_star;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_13;
