class Ex2_18
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real T_e(unit="K")=288.16;/*temperature at nozzle exit*/
parameter Real p_e(unit="N/m^2")=101325;/*pressure at nozzle exit*/
parameter Real rho_e(unit="kg/m^3")=1.225;/*density at nozzle exit*/

parameter Real M=2.3;/*Mach number at the exit*/

Real T_0(unit="K");/*temperature at reservior*/
Real p_0(unit="N/m^2");/*pressure at reservior*/
Real Ae_At;/*area ratio*/
equation
T_0=T_e*(1+((gama-1)/2)*M^2);
p_0=p_e*(1+((gama-1)/2)*M^2)^(gama/(gama-1));
Ae_At=sqrt((1/M^2)*((2/(gama+1))*(1+((gama-1)/2)*M^2))^((gama+1)/(gama-1)));
end Ex2_18;
