class Ex2_2
/*velocity conversion 1 m/s=(10^(-3) km)/(3600^(-1)) h =3.6 km/h */

parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real M=1.6;/*Mach number of the aircraft*/

/* for 2000 m altitude*/
parameter Real p1(unit="N/m^2")=90*10^3;/*pressure at altitude 2000 m */
parameter Real rho1(unit="kg/m^3")=1.113;/*density of air at altitude 2000 m */
Real C1(unit="m/s");/*speed of sound at altitude 2000 m */
Real V1(unit="m/s");/*velocity of aircraft at altitude 2000 m in m/s unit*/
Real V1_kmph(unit="km/h");/*velocity of aircraft at altitude 2000 m in km/h unit*/

/* for 10000 m altitude*/
parameter Real p2(unit="N/m^2")=29.3*10^3;/*pressure at altitude 10000 m */
parameter Real rho2(unit="kg/m^3")=0.42;/*density of air at altitude 10000 m */
Real C2(unit="m/s");/*speed of sound at altitude 10000 m */
Real V2(unit="m/s");/*velocity of aircraft at altitude 10000 m in m/s unit*/
Real V2_kmph(unit="km/h");/*velocity of aircraft at altitude 10000 m in km/h unit*/   

equation
/* for 2000 m altitude*/
C1=sqrt((gama*p1)/rho1);
M=V1/C1;
V1_kmph=V1*3.6;

/* for 10000 m altitude*/
C2=sqrt((gama*p2)/rho2);
M=V2/C2;
V2_kmph=V2*3.6;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_2;
