class Ex2_3
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real M=2.4;/*Mach number of the aircraft*/

parameter Real T_deg(unit="degC")=22;/*temperature of the air in degree celcius unit*/
Real T(unit="K");/*temperature of the air in Kelvin unit*/

Real C(unit="m/s");/*speed of sound*/
Real V(unit="m/s");/*velocity of aircraft*/

parameter Real AC(unit="m")=2000;/*altitude of aircraft above observer*/
Real AB(unit="m");/*distance travelled by aircrat in time t*/
Real alpha(unit="rad");/*angle of Mach cone*/

Real t(unit="s");/*time elapsed in the bang to reach ground*/
equation
T=Modelica.SIunits.Conversions.from_degC(T_deg);
C=sqrt(gama*R*T);
M=V/C;
AB=AC/tan(alpha);
sin(alpha)=(1/M);
AB=V*t;
/*given answer in the book is wrong as two different Mach number has been used to calculate the answe*/
end Ex2_3;
