class Ex2_4
/*velocity conversion 1 m/s=(10^(-3) km)/(3600^(-1)) h =3.6 km/h */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/



parameter Real T_deg(unit="degC")=12;/*temperature of the air in degree celcius unit*/
Real T(unit="K");/*temperature of the air in Kelvin unit*/
Real C(unit="m/s");/*speed of sound*/

parameter Real t(unit="s")=9.5;/*time elapsed in the bang to reach ground*/
parameter Real MP(unit="m")=4000;/*altitude of aircraft above ground*/
Real alpha(unit="rad");/*angle of Mach cone*/

Real M;/*Mach number of the aircraft*/
Real V(unit="m/s");/*velocity of aircraft*/
Real V_kmph(unit="km/h");/*velocity of aircraft at altitude 10000 m in km/h unit*/
equation
T=Modelica.SIunits.Conversions.from_degC(T_deg);
C=sqrt(gama*R*T);

cos(alpha)=(C*t)/MP;
sin(alpha)=1/M;

M=V/C;
V_kmph=V*3.6;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_4;
